﻿-- ■==============================================================================================■*/
--[[ !
    @file		ghost_highway_route_OHSHU.lua
    @brief		全国街道チャレンジ ルート情報(奥州街道)
    @author		AutoGenerated (otsuka-y)
    @date		2019/10/11 16:12:49
--]]
-- ■==============================================================================================■*/
-- ルートファイルのID
ROUTE_ID = "OHSHU"
-- ルート名
ROUTE_NAME = "奥州街道"

-- 門番・ボス分身を撃破することで入手可能な報酬
---- 記法
--   アイテムID, 報酬ID,
---- 報酬ID
--   どのマスの分身を倒した時にどの報酬を受け取るかを紐付ける(201-299)
RewardTable = {
	[CAT_STAMP] = {
		150,211,
		151,212,
		152,213,
		136,214,
	},
	[CAT_HONOR] = {
		630017,211,
		630018,212,
		630019,213,
		630003,214,
	},

}

-- マス情報
---- 記法
-- マス種別, 関所とショートカット先ID, 報酬ID
----マス種別
--   SHOP,          //! 店舗マス
--   START,         //! スタートマス
--   MANUFARACTUER, //! メーカーマス
--   RECENT,        //! 最近プレイした相手マス
--   UNKNOWN,       //! ハテナマス
--   BONUS,         //! ボーナスマス
--   STATION,       //! 関所分身マス
--   BOSS,          //! ボス分身マス
--   BLANK,         //! 空白マス
---- 関所とショートカット先ID
-- 関所とショートカット先に対して同じIDを使用する (101-199)
---- 報酬ID
-- どのマスの分身を倒した時にどの報酬を受け取るかを紐付ける (201-299)
SquareTable = {
	START,
	SHOP,
	RECENT,
	MANUFARACTUER,
	RECENT,
	UNKNOWN,
	SHOP,
	RECENT,
	STATION,	107,	211,
	MANUFARACTUER,
	SHOP,
	UNKNOWN,
	RECENT,	107,
	MANUFARACTUER,
	SHOP,
	RECENT,
	MANUFARACTUER,
	BONUS,
	RECENT,
	UNKNOWN,
	MANUFARACTUER,
	RECENT,
	SHOP,
	RECENT,
	BONUS,
	RECENT,
	RECENT,
	MANUFARACTUER,
	SHOP,
	RECENT,
	SHOP,
	BONUS,
	SHOP,
	RECENT,
	MANUFARACTUER,
	RECENT,
	UNKNOWN,
	STATION,	108,	212,
	BLANK, --
	MANUFARACTUER,
	BLANK, --
	UNKNOWN,
	BLANK, --
	MANUFARACTUER,
	BLANK, --
	RECENT,	108,
	SHOP,
	RECENT,
	MANUFARACTUER,
	BONUS,
	RECENT,
	SHOP,
	RECENT,
	SHOP,
	RECENT,
	BONUS,
	RECENT,
	SHOP,
	RECENT,
	UNKNOWN,
	RECENT,
	STATION,	109,	213,
	SHOP,
	SHOP,
	MANUFARACTUER,
	BOSS,	109,	214,

}

-- 関所・ボス分身の情報テーブル
---- 記法
-- 車ID, 走行エリアID
---- 走行エリアID
--  Ａ１０１―３．分身・乱入・イベントモードのコースデータ→area IDに
-- 指定されている数値を指定 (0-17)
BarrierEmenyTable = {
	2018,
	2019,
	2020,
	2004,4,

}

-- 双六マスインデント情報のテーブル(手動指定専用)
-- -- 記法
-- (通常ライン)          最初マスのインデント, 終了マスのインデント,
-- (ショートカットライン)最初マスのインデント, 終了マスのインデント,
-- 通常ライン
-- ショートカットライン
-- 通常ライン… これらをライン数分指定する
-- いずれのラインのインデントも設定しない場合はテーブル内は空欄でも可だが、
-- 1ラインでも指定する場合は、インデントしないラインは全て0で埋めること
LineIndentTable = {
	160,155,
	160,155,
	120,67,
	130,75,
	55,75,
	210,90,
	310,370,
	0,0,

}

-- 関所名リストテーブル
-- -- 記法
-- 関所名,
-- flashの関所名表示にのみ使用する
StationNameTable = {
	"Shirakawa",
	"Oniyanagi",
	"Nouchi",

}

function GetRewardTable ( category_id )
    return unpack( RewardTable[category_id] )
end

function GetSquareTable( )
    return unpack( SquareTable )
end

function GetBarrierEnemyTable( )
    return unpack( BarrierEmenyTable )
end

function GetRouteName()
    return ROUTE_NAME
end

function GetLineIndentTable()
    return unpack( LineIndentTable )
end

function LineIndentTableSize()
    return #LineIndentTable
end

function GetStationNameTable()
    return unpack( StationNameTable )
end

function GetStationNameTableSize()
    return #StationNameTable
end
